﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AdmZatrudnienieOkresy.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.AdmZatrudnienieOkresy" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Okresy zatrudnienia</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {

            $("#btnPowrot").button({ icons: { primary: 'ui-icon-arrowreturnthick-1-w' } });
            $(".btnWybierzGrid").button({ icons: { primary: 'ui-icon-check' } });

        });

    </script>
</head>
<body class="Table" oncontextmenu="return false" style="margin-left: 0; margin-right: 0; margin-top: 0">
    <form id="Form1" method="post" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server"></asp:Label>
            <asp:Label ID="lblKomunikat" runat="server"></asp:Label>
            <div style="height: 20px; float: right;">
                <asp:Button ID="btnPowrot" runat="server" Text="Powrót" CssClass="aspButton" OnClick="btnPowrot_Click" ></asp:Button>
            </div>
            <div style="clear:both;"></div>
            <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                <div style="float: left; position: absolute; bottom: 2px;">
                    <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                </div>
            </div>
            <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_CZASU_UMOWY,ID_UMOWY_SLOWNIK,ID_OKRESU_UMOWY,NAZWA,KOD,OPIS" OnRowCommand="gvListy_RowCommand">
                <Columns>
                    <asp:TemplateField ShowHeader="False">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbWybierzGrid" class="btnWybierzGrid" runat="server" CausesValidation="false" CommandName="WYBIERZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Wybierz"></asp:LinkButton>
                        </ItemTemplate>
                        <ItemStyle VerticalAlign="Middle" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="KOD" HeaderText="Kod" SortExpression="KOD" />
                    <asp:BoundField DataField="NAZWA" HeaderText="Nazwa" SortExpression="NAZWA" />
                    <asp:BoundField DataField="OPIS" HeaderText="Opis" SortExpression="OPIS" />
                </Columns>
                <PagerSettings Position="Top" />
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="AK_CZASY_UMOW_LIST" SelectCommandType="StoredProcedure" ConnectionString="r" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected" OnSelecting="sdsListy_Selecting">
                <SelectParameters>
                    <asp:Parameter Name="P_ID_UMOWY_SLOWNIK" />
                    <asp:Parameter Name="P_BEZ_PROBNY" Type="string" Direction="Input" DefaultValue="T" />
                </SelectParameters>
            </asp:SqlDataSource>
        </div>
    </form>
</body>
</html>
